package net.w_horse.excelpojo.excel;

import java.lang.annotation.Annotation;


import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;
import net.w_horse.excelpojo.xml.ExcelPOJOXmlParser;

import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.w3c.dom.Element;


public class HorizontalRepeatsSeeker extends AbstractRepeatsSeeker {

	@Override
	public void set(Element element, ExcelPOJOXmlParser parser) {
		parser.setCellSeeker(element, this);
	}

	@Override
	public void set(Annotation annotation, ExcelPOJOAnnotationParser parser) throws ClassNotFoundException, LinkageError {
		parser.setCellSeeker(annotation, this);
	}

	@Override
	int getRowLimit(HSSFSheet sheet) {
        int colSizeMax = 0;
        for (int i = 0; i < sheet.getLastRowNum(); i++) {
            HSSFRow row = sheet.getRow(i);
            if (row == null) continue;

            int colSize = row.getLastCellNum();
            if (colSize > colSizeMax) {
                colSizeMax = colSize;
            }
        }
		return colSizeMax;
	}

	@Override
	Offset getOffset(int rowIndex) {
		return new Offset(0, rowIndex);
	}

	@Override
	Offset getOffset4MappedCell(int rowIndex) {
		return new Offset(rowIndex +1, -1);
	}

}
